CREATE FUNCTION [dbo].[CFUJ_Venta_Abono_Lista_Renovacion](@pJson VARCHAR(8000))
RETURNS SMALLINT
AS
BEGIN


/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug							TINYINT
DECLARE @pId_Cliente						INT
DECLARE @pId_Lista_Precio_Abono_Origen		SMALLINT
DECLARE @pFecha								DATETIME

SET @pModoDebug							= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), '')
SET @pId_Cliente						= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Lista_Precio_Abono_Origen		= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio_Abono_Origen')), 0)
SET @pFecha								= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), GETDATE())
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Id_Lista_Precio_Abono_Destino			SMALLINT
/*FIN Variables Locales*/

-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------

--IMPLEMENTACIONES
--17/05/2022: Se crea la funcion

-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------

/*
EJEMPLO Se utiliza para Kiosk, al momento de renovaciones de abonos se recibe por parametro el id_Lista_PRecio del abono vencido(origen) y lo convierte a la lista de precios nueva (renovacion nueva): 
IF (@pId_Lista_Precio_Abono_Origen IN (	521, /*ABONO  1 SEMESTRE 2022 (hasta 22-1)*/
										522, /*ABONO  1 SEMESTRE 2022 */
										523, /*RENOVAR ABONO 1 SEMEST 2022(Precio Hasta 22)*/
										524) /*RENOVAR ABONO 1 SEMEST 2022*/
										) /* Listas del Primer semestre 2022*/
BEGIN
	IF @pFecha < '20220527'
	BEGIN
		SET @Id_Lista_Precio_Abono_Destino = 547 /*Lista Renovacin del 2 Semestre*/
	END
	ELSE 
	BEGIN
		SET @Id_Lista_Precio_Abono_Destino = 548 /*Lista Renovacin 2 Semestre 2022 - Sin descuento del 27/5 al 3/6*/
	END
END
*/
-----------------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@Id_Lista_Precio_Abono_Destino, @pId_Lista_Precio_Abono_Origen)
END
